﻿using System;
using System.Xml;
using System.Xml.XPath;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Wordprocessing;

namespace csharp
{
    class CteniMetadat
    {
        static void Main(string[] args)
        {
            // otevření WordprocessingML dokumentu
            using (WordprocessingDocument wpDoc = 
                   WordprocessingDocument.Open("..\\..\\..\\..\\wordprocessingml\\zahlavi.docx", false))
            {
                // načtení části s metadaty do paměti
                XPathDocument metaDoc = new XPathDocument(wpDoc.CoreFilePropertiesPart.GetStream());
                
                // vytvoření navigátoru
                XPathNavigator nav = metaDoc.CreateNavigator();

                // namespacemanager pro mapování prefixů na jmenné prostory
                XmlNamespaceManager manager = new XmlNamespaceManager(nav.NameTable);
                manager.AddNamespace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
                manager.AddNamespace("dc", "http://purl.org/dc/elements/1.1/");

                // vytažení dat pomocí XPathu
                Console.WriteLine("Název dokumentu: " + 
                                  nav.Evaluate("string(/*/dc:title)", manager));

                Console.WriteLine("Autor dokumentu: " +
                                  nav.Evaluate("string(/*/dc:creator)", manager));

                // načtení hlavní části s dokumentem do paměti
                XPathDocument doc = new XPathDocument(wpDoc.MainDocumentPart.GetStream());

                // načtení druhého dokumentu do navigátoru
                nav = doc.CreateNavigator();

                // vytažení dat pomocí XPathu
                Console.WriteLine("Počet odstavců: " +
                                  nav.Evaluate("count(//w:p)", manager));

                // rychlý přístup k w:body pomocí "otypovaného DOMu" 
                int citac = 0;
                foreach (Paragraph p in wpDoc.MainDocumentPart.Document.Body.Descendants<Paragraph>())
                {
                    citac++;
                }

                Console.WriteLine("Počet odstavců jinak: " + citac);

            }

            Console.ReadLine();
        }
    }
}