﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.IO;
using System.IO.Packaging;
using System.Xml.Linq;

namespace csharp
{
    class CteniWordMLXlinq
    {
        static void Main(string[] args)
        {
            // otevření balíčku s dokumentem
            Package package = Package.Open("..\\..\\..\\..\\wordprocessingml\\prace-se-styly.docx", 
                FileMode.Open, FileAccess.Read);

            // získání URI části, ve které je část s dokumentem
            Uri uriDocumentTarget = PackUriHelper.ResolvePartUri(
                        new Uri("/", UriKind.Relative), 
                                package.GetRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").First().TargetUri);

            // načtení dokumentu do paměti
            XDocument doc = XDocument.Load(new StreamReader(package.GetPart(uriDocumentTarget).GetStream()));

            // jmenný prostor pro WordprocessingML
            XNamespace w = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";

            // Linq to XML dotaz nad dokumentem
            IEnumerable<string> texty =
                from t in doc.Descendants(w + "t")
                select (string)t;

            // průchod uzly s textem výsledku
            foreach (string s in texty)
            {
                Console.WriteLine(s);
            }

            Console.ReadLine();
        }
    }
}