﻿using System;
using System.IO;
using System.Xml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Wordprocessing;
using System.Xml.Linq;

namespace csharp
{
    class OpravenaModifikaceWordML
    {
        static void Main(string[] args)
        {
            // kopie původního dokumentu do nového
            File.Copy("..\\..\\..\\..\\wordprocessingml\\prace-se-styly.docx",
                      "schvaleno.docx", true);

            // otevření dokumentu
            using (WordprocessingDocument package =
                   WordprocessingDocument.Open("schvaleno.docx", true))
            {
                // vytvoření nového odstavce
                Paragraph p = new Paragraph(new Run(new Text("Schváleno")));

                // nalezení těla dokumentu (w:body)
                Body body = package.MainDocumentPart.Document.Body;

                // načtení posledního dítěte těla
                OpenXmlElement last = body.LastChild;

                // element w:sectPr musí být vždy poslední
                if (last is SectionProperties)
                    body.InsertBefore(p, last);
                else
                    body.AppendChild(p);

                // zapsání dokumentu zpět do balíčku
                package.MainDocumentPart.Document.Save();

                Console.WriteLine("Dokument byl uložen jako schvaleno.docx a byl schválen.");
                Console.Write("Validuji dokument...");

                // validace dokumentu
                package.MainDocumentPart.ValidateXml("..\\..\\..\\..\\xsd\\wml.xsd", null);

                Console.WriteLine("OK");
            }

 
            Console.ReadLine();
        }
    }
}