<?php

// nastavení typu generovaných dat
Header("Content-type: text/html;charset=utf-8");

// cesta k načítanému dokumentu
$docxFilename = realpath("../wordprocessingml/zahlavi.docx");

// načtení části se vztahy jako dokument DOM do paměti
$relsDoc = DOMDocument::loadXML(file_get_contents("zip://$docxFilename#_rels/.rels"));

// vytvoření objektu pro vyhodnocování dotazů XPath
$relsXPath = new DOMXPath($relsDoc);

// zaregistrování prefixu pro jmenný prostor vztahů
$relsXPath->registerNamespace("r", "http://schemas.openxmlformats.org/package/2006/relationships");

// nalezení hlavní části se samotným dokumentem
$documentPartUri = $relsXPath->evaluate("string(/r:Relationships/r:Relationship[@Type = 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument']/@Target)");

// načtení hlavní části dokumentu do stromu DOM v paměti
$doc = DOMDocument::loadXML(file_get_contents("zip://$docxFilename#$documentPartUri"));

// vytvoření objektu pro vyhodnocování dotazů XPath
$xpath = new DOMXPath($doc);

// zaregistrování prefixu a pro jmenný prostor WordprocessingML
$xpath->registerNamespace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");

echo "Statistika dokumentu: " . $docxFilename . "<br>\n";

// počítání různých statistik
echo "Počet odstavců v dokumentu: " . $xpath->evaluate("count(//w:p)") . "<br>\n";

// vyběr všech textů
$celyText = "";
$texty = $xpath->query("//w:t");

foreach ($texty as $t)
{
  $celyText .= $t->textContent;
}

echo "Počet znaků: " . strlen($celyText) . "<br>\n";
echo "Počet slov: " . str_word_count($celyText) . "<br>\n";

?>