﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.IO.Packaging;
using System.Xml.XPath;
using System.Xml;

namespace csharp
{
    class CteniWordMLDOM
    {
        static void Main(string[] args)
        {
            // otevření balíčku s dokumentem
            Package package = Package.Open("..\\..\\..\\..\\wordprocessingml\\prace-se-styly.docx", 
            //Package package = Package.Open("..\\..\\..\\..\\opc\\vlastni-struktura-archivu.docx", 
                FileMode.Open, FileAccess.Read);

            // získání URI části, ve které je část s dokumentem
            Uri uriDocumentTarget = PackUriHelper.ResolvePartUri(
                        new Uri("/", UriKind.Relative), 
                                package.GetRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").First().TargetUri);

            // vytvoření nového dokumentu DOM
            XmlDocument doc = new XmlDocument();

            // načtení části s dokumentem do paměti
            doc.Load(package.GetPart(uriDocumentTarget).GetStream());

            // průchod uzly s textem
            foreach (XmlElement element in doc.GetElementsByTagName("t", "http://schemas.openxmlformats.org/wordprocessingml/2006/main"))
            {
                Console.WriteLine(element.InnerText);
            }

            Console.ReadLine();
        }
    }
}