﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.IO.Packaging;
using System.Xml.XPath;
using System.Xml;

namespace csharp
{
    class CteniWordMLXPath
    {
        static void Main(string[] args)
        {
            // otevření balíčku s dokumentem
            Package package = Package.Open("..\\..\\..\\..\\wordprocessingml\\prace-se-styly.docx", 
                FileMode.Open, FileAccess.Read);

            // získání URI části, ve které je část s dokumentem
            Uri uriDocumentTarget = PackUriHelper.ResolvePartUri(
                        new Uri("/", UriKind.Relative), 
                                package.GetRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").First().TargetUri);

            // načtení části s dokumentem do paměti
            XPathDocument doc = new XPathDocument(
              package.GetPart(uriDocumentTarget).GetStream());

            // navigátor pro vyhodnocování XPath výrazů
            XPathNavigator nav = doc.CreateNavigator();

            // namespacemanager pro mapování prefixů na jmenné prostory
            XmlNamespaceManager manager = new XmlNamespaceManager(nav.NameTable);
            manager.AddNamespace("w", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");

            // vybrání všech textů z dokumentu
            XPathNodeIterator nodes = nav.Select("//w:t", manager);

            // průchod uzly s textem
            while (nodes.MoveNext())
            {
                Console.WriteLine(nodes.Current.Value);
            }

            Console.ReadLine();
        }
    }
}