﻿using System;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Wordprocessing;

namespace csharp
{
    class GenerovaniWordML
    {
        static void Main(string[] args)
        {
            // vytvoření WordprocessingML dokumentu
            using (WordprocessingDocument package =
                   WordprocessingDocument.Create("pozdrav.docx", WordprocessingDocumentType.Document))
            {
                // přidání hlavní části do balíčku
                package.AddMainDocumentPart();

                // vytvoření DOMu dokumentu
                package.MainDocumentPart.Document =
                  new Document(
                    new Body(
                      new Paragraph(
                        new Run(
                          new RunProperties(
                            new Bold()),
                          new Text("Ahoj Světě!"))),
                      new Paragraph(
                        new Run(
                          new RunProperties(
                            new Color() { Val = "FF0000" },
                            new FontSize() { Val = 72}),
                          new Text("Nazdar")
                          ))));

                // uložení změn do hlavní části balíčku
                package.MainDocumentPart.Document.Save();
            }

            Console.WriteLine("Soubor pozdrav.docx byl vytvořen.");
            Console.ReadLine();
        }
    }
}