﻿using System;
using System.IO;
using System.Xml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Wordprocessing;

namespace csharp
{
    class ModifikaceWordMLDOM
    {
        static void Main(string[] args)
        {
            // kopie původního dokumentu do nového
            File.Copy("..\\..\\..\\..\\wordprocessingml\\prace-se-styly.docx", 
                      "schvaleno.docx", true);

            // otevření dokumentu
            using (WordprocessingDocument package =
                   WordprocessingDocument.Open("schvaleno.docx", true))
            {
                // načtení hlavní části do DOM
                XmlDocument doc = new XmlDocument();
                doc.Load(package.MainDocumentPart.GetStream());

                // nalezení elementu w:body
                XmlElement body = (XmlElement) doc.GetElementsByTagName("body", "http://schemas.openxmlformats.org/wordprocessingml/2006/main").Item(0);

                // vytvoření nového odstavce
                XmlElement novyPara = doc.CreateElement("p", "http://schemas.openxmlformats.org/wordprocessingml/2006/main");
                novyPara.InnerXml = @"<w:r xmlns:w='http://schemas.openxmlformats.org/wordprocessingml/2006/main'>
                                        <w:t>Schváleno!!!</w:t>
                                      </w:r>";

                // připojení nového odstavce na konec dokumentu
                body.AppendChild(novyPara);

                // zapsání dokumentu DOM zpět do balíčku
                doc.Save(package.MainDocumentPart.GetStream(FileMode.Create));
            }

            Console.WriteLine("Dokument byl uložen jako schvalono.docx a byl schválen.");
            Console.ReadLine();
        }
    }
}