<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main">

  <xsl:output indent="yes"/>

  <!-- Some document structure checks -->
  <xsl:template match="/">
    <xsl:if test="count(//w:customXml/ancestor-or-self::w:customXml[last()]) > 1">
      <xsl:message>Produced XML document will not be WF and will have more then one root element.</xsl:message>
    </xsl:if>
    <!-- Process content of document -->
    <xsl:apply-templates/>
  </xsl:template>

  <!-- copy over custom XML elements -->
  <xsl:template match="w:customXml">
    <xsl:element name="{@w:element}" namespace="{@w:uri}">
      <!-- copy over attribute values -->
      <xsl:for-each select="w:customXmlPr/w:attr">
        <xsl:attribute name="{@w:name}" namespace="{@w:uri}">
          <xsl:value-of select="@w:val"/>
        </xsl:attribute>
      </xsl:for-each>
      <!-- process content -->
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  
  <!-- copy over only text inside custom XML -->
  <xsl:template match="text()[ancestor::w:customXml[not(.//w:customXml)]]" priority="10">
    <xsl:value-of select="."/>
  </xsl:template>

  <!-- warn about mixed content -->
  <xsl:template match="text()[ancestor::w:customXml]" priority="5">
    <xsl:message>Stripping "<xsl:value-of select="."/>" from output.</xsl:message>
    <xsl:message>This text is part of mixed content and would cause non-valid result.</xsl:message>
  </xsl:template>
  
  <!-- warn about text which is not tagged -->
  <xsl:template match="text()">
    <xsl:message>Stripping "<xsl:value-of select="."/>" from output.</xsl:message>
    <xsl:message>This text is not enclosed by root element and would cause non-WF result.</xsl:message>
  </xsl:template>
  
  <!-- do not pick up deleted content -->
  <xsl:template match="w:del|w:moveFrom"/>

</xsl:stylesheet>
