<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:o="http://example.org/objednavka">

<xsl:template match="/">
  <fo:root>
    <!-- Definice layoutu stránky -->
    <fo:layout-master-set>
      <!-- Rozměry stránky a její okraje -->
      <fo:simple-page-master master-name="my-page"
        page-height="297mm" page-width="210mm" margin="1in">
        <!-- Tiskové zrcadlo - oblast pro samotný obsah stránky -->
        <fo:region-body/>        
      </fo:simple-page-master>
    </fo:layout-master-set>
    
    <!-- Definice obsahu stránky -->
    <fo:page-sequence master-reference="my-page">
      <!-- Samotný text dokumentu -->
      <fo:flow flow-name="xsl-region-body" 
               font-family="Arial,Helvetica,sans-serif"
               font-size="12pt">

         <fo:block font-size="36pt" font-weight="bold" space-after="12pt">
           Objednávka
         </fo:block>
        
        <fo:block>
          Objednávka od 
            <fo:inline font-style="italic" color="red">
              <xsl:value-of select="/o:objednavka/o:od"/>
            </fo:inline>          
        </fo:block>
        
        <fo:table width="100%" border="solid 2pt black"
          border-collapse="collapse" space-before="12pt">
          <fo:table-column column-width="70%"/>
          <fo:table-column column-width="30%"/>
          <fo:table-body>
            <fo:table-row background-color="#999999" font-weight="bold">
              <fo:table-cell xsl:use-attribute-sets="bunka">
                <fo:block>Název</fo:block>
              </fo:table-cell>              
              <fo:table-cell xsl:use-attribute-sets="bunka">
                <fo:block>Počet</fo:block>
              </fo:table-cell>              
            </fo:table-row>
            
            <!-- Iterace přes všechny položky -->
            <xsl:for-each select="o:objednavka/o:polozky/o:polozka">
              <fo:table-row>
                <fo:table-cell xsl:use-attribute-sets="bunka">
                  <fo:block><xsl:value-of select="o:nazev"/></fo:block>
                </fo:table-cell>              
                <fo:table-cell xsl:use-attribute-sets="bunka">
                  <fo:block><xsl:value-of select="o:pocet"/></fo:block>
                </fo:table-cell>              
              </fo:table-row>
            </xsl:for-each>
            
          </fo:table-body>
        </fo:table>        
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>

<xsl:attribute-set name="bunka">
  <xsl:attribute name="border">solid 1pt black</xsl:attribute>
  <xsl:attribute name="padding">2pt</xsl:attribute>
</xsl:attribute-set>

</xsl:stylesheet>