<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                version="2.0"
                xmlns:r="http://schemas.openxmlformats.org/package/2006/relationships"
                xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                exclude-result-prefixes="r w dc">

  <!-- Parametr pro předání adresy dokumentu, který chceme zpracovávat -->
  <xsl:param name="url">file:../wordprocessingml/zahlavi.docx</xsl:param>

  <!-- Proměnné zastupující jednotlivé části uvnitř OOXML souboru -->
  <!-- Schéma jar: umožňuje transparentní přístup k archivum ZIP/JAR -->
  <xsl:variable name="rels" 
                select="doc(concat('jar:', $url, '!/_rels/.rels'))"/>
  
  <!-- URI hlavní části v balíčku -->
  <xsl:variable name="mainPartUri"
                select="$rels/r:Relationships/r:Relationship[@Type = 'http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument']/@Target"/>
  
  <!-- Dokument hlavní části -->
  <xsl:variable name="doc" 
                select="doc(concat('jar:', $url, '!/', $mainPartUri))"/>
  
  <!-- URI části s metadaty -->
  <xsl:variable name="metaPartUri"
                select="$rels/r:Relationships/r:Relationship[@Type = 'http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties']/@Target"/>

  <!-- Dokument s metadaty -->
  <xsl:variable name="meta" 
                select="doc(concat('jar:', $url, '!/', $metaPartUri))"/>
  

  <!-- Šablona, kterou transformace začíná -->
  <xsl:template name="stat">
    <html>
      <head>
        <title>Statistika dokumentu 
          <xsl:value-of select="$meta/*/dc:title"/>
        </title>
      </head>
      <body>
        Název dokumentu: <xsl:value-of select="$meta/*/dc:title"/><br/>
        Autor dokumentu: <xsl:value-of select="$meta/*/dc:creator"/><br/>
        Počet odstavců: <xsl:value-of select="count($doc//w:p)"/><br/>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>