<?
//
// czdate.php       (c) Jirka Kosek 1998, xkosj06@vse.cz
//
// string CZDate(string format_string, [int timestamp])
// outputs formatted date/time information with Czech locales
//

define("CZDate_NoModification", "UUYymzdwHhis", 1);
define("CZDate_Modification", "FFMlDAae", 1);
                // Doubling first letters hacks error in strrpos

$CZDate_Months = array (1=>"ledna", "nora", "bezna", 
                       "dubna", "kvtna", "ervna",
                       "ervence", "srpna", "z", 
                       "jna", "listopadu", "prosince");

$CZDate_ShortMonths = array (1=>"Led", "no", "Be", 
                       "Dub", "Kv", "en",
                       "ec", "Srp", "Z", 
                       "j", "Lis", "Pro");

$CZDate_Days = array (1=>"Pondl", "ter", "Steda", "tvrtek",
                     "Ptek", "Sobota", "Nedle");

$CZDate_ShortDays = array (1=>"Po", "t", "St", "t", "P", "So", "Ne");

function CZDate($format, $timestamp = -1)
{
    global $CZDate_Months, $CZDate_ShortMonths, 
           $CZDate_Days, $CZDate_ShortDays;

    if ($timestamp==-1) $timestamp = time();
    $r = "";
    for ($i=0; $i<strlen($format); $i++):
      if (strrpos(CZDate_NoModification, $format[$i])):
        $r .= Date($format[$i], $timestamp);
      elseif (!strrpos(CZDate_Modification, $format[$i])):
        $r .= $format[$i];
      else:
        switch ($format[$i]):
        case "F":
          $r .= $CZDate_Months[(int)Date("m", $timestamp)];
          break;
        case "M":  
          $r .= $CZDate_ShortMonths[(int)Date("m", $timestamp)];
          break;
        case "l":  
          $r .= $CZDate_Days[(int)Date("w", $timestamp)];
          break;
        case "D":  
          $r .= $CZDate_ShortDays[(int)Date("w", $timestamp)];
          break;
        case "A":
          $r .= Date("A", $timestamp)=="AM" ? "DOPOL." : "ODPOL.";
          break;
        case "a":
          $r .= Date("A", $timestamp)=="AM" ? "dopol." : "odpol.";
          break;
        case "e":
          $r .= (int)Date("d", $timestamp);
          break;
        endswitch;  
      endif;
    endfor;
    return $r;
}

echo CZDate("l e. F Y");

?>
